/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef STATUSCHECK_H
#define STATUSCHECK_H

//#include <QtSerialPort/QSerialPort>
#include <QDebug>
#include <QList>
#include <QMap>
#include <QSerialPort>
#include <QString>
#include <QTimer>
#include "serial_v3.h"

class  StatusCheck : public QObject
{
	Q_OBJECT

public:

	//
	// TODO:
	// Legacy StatusCheck public items to be deleted.
	//
	StatusCheck(QSerialPort *SG_port, QString channel_select, QString messages_file, bool console_output_enabled = true);
	void clear_error();

	//
	// TODO:
	// These public items are used in the reworked StatusCheck and should be kept.
	//
	StatusCheck(Serial *port, QString messages_file);
	QStringList translate_SG_error(quint64 error);
	QMap<QString, QString> error_map;


public slots:
	//
	// TODO:
	// Legacy StatusCheck items to be deleted.
	//
	void poll_SG_error();

private:
	//
	// TODO:
	// Legacy StatusCheck private items to be deleted.
	//
	QSerialPort *SG_port;

	bool console_output_enabled;
	QString channel_select = "1";

	quint64	status;				//SG status code
	quint64	error = 0;			//SG error code
	quint64	last_error = 0;		//Store the last known error state.
	bool RF_status = true;

	void ST_parser();
	bool ECG_parser();

	//
	// TODO:
	// SGX_port should be deleted, but requires the new StatusCheck to be modified a bit.
	//
	Serial *SGX_port;

signals:

	void SG_error_signal(quint64 *);
	void RF_disabled_signal();
	void reset_detected_signal();

};

#endif // STATUSCHECK_H
